using System;

namespace Server.Items
{
	public abstract class BaseSilkShirt : BaseClothing
	{
		public BaseSilkShirt( int itemID ) : this( itemID, 0 )
		{
		}

		public BaseSilkShirt( int itemID, int hue ) : base( itemID, Layer.Shirt, hue )
		{
		}

        public BaseSilkShirt(Serial serial)
            : base(serial)
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}

	[FlipableAttribute( 0x1efd, 0x1efe )]
	public class FancySilkShirt : BaseSilkShirt
	{
        public override int BasePhysicalResistance { get { return 2; } }
        public override int BaseFireResistance { get { return 1; } }
        public override int BaseColdResistance { get { return 2; } }
        public override int BasePoisonResistance { get { return 4; } }
        public override int BaseEnergyResistance { get { return 3; } }

        public override int InitMinHits { get { return 10; } }
        public override int InitMaxHits { get { return 20; } }

		[Constructable]
		public FancySilkShirt() : this( 0 )
		{
		}

		[Constructable]
		public FancySilkShirt( int hue ) : base( 0x1EFD, hue )
		{
			Weight = 2.0;
            Name = "Fancy Silk Shirt";
		}

        public FancySilkShirt(Serial serial)
            : base(serial)
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}

	[FlipableAttribute( 0x1517, 0x1518 )]
	public class SilkShirt : BaseSilkShirt
	{
        public override int BasePhysicalResistance { get { return 2; } }
        public override int BaseFireResistance { get { return 1; } }
        public override int BaseColdResistance { get { return 2; } }
        public override int BasePoisonResistance { get { return 4; } }
        public override int BaseEnergyResistance { get { return 1; } }

        public override int InitMinHits { get { return 25; } }
        public override int InitMaxHits { get { return 30; } }

		[Constructable]
		public SilkShirt() : this( 0 )
		{
		}

		[Constructable]
		public SilkShirt( int hue ) : base( 0x1517, hue )
		{
			Weight = 1.0;
            Name = "Silk Shirt";
		}

        public SilkShirt(Serial serial)
            : base(serial)
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();

			if ( Weight == 2.0 )
				Weight = 1.0;
		}
	}

	[Flipable( 0x2794, 0x27DF )]
	public class SilkNinjaJacket : BaseSilkShirt
	{
        public override int BasePhysicalResistance { get { return 2; } }
        public override int BaseFireResistance { get { return 3; } }
        public override int BaseColdResistance { get { return 3; } }
        public override int BasePoisonResistance { get { return 4; } }
        public override int BaseEnergyResistance { get { return 2; } }

        public override int InitMinHits { get { return 25; } }
        public override int InitMaxHits { get { return 30; } }

		[Constructable]
		public SilkNinjaJacket() : this( 0 )
		{
		}

		[Constructable]
		public SilkNinjaJacket( int hue ) : base( 0x2794, hue )
		{
			Weight = 5.0;
			Layer = Layer.InnerTorso;
            Name = "Silk Ninja Jacket";
		}

        public SilkNinjaJacket(Serial serial)
            : base(serial)
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}

	public class SilkElvenShirt : BaseSilkShirt
	{

        public override int BasePhysicalResistance { get { return 2; } }
        public override int BaseFireResistance { get { return 1; } }
        public override int BaseColdResistance { get { return 2; } }
        public override int BasePoisonResistance { get { return 4; } }
        public override int BaseEnergyResistance { get { return 1; } }

        public override int InitMinHits { get { return 25; } }
        public override int InitMaxHits { get { return 30; } }

		public override Race RequiredRace { get { return Race.Elf; } }

		[Constructable]
		public SilkElvenShirt() : this( 0 )
		{
		}

		[Constructable]
		public SilkElvenShirt( int hue ) : base( 0x3175, hue )
		{
			Weight = 2.0;
            Name = "Elven Silk Shirt";
		}

        public SilkElvenShirt(Serial serial)
			: base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.WriteEncodedInt( 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadEncodedInt();
		}
	}

    public class SilkElvenDarkShirt : BaseSilkShirt
	{
        public override int BasePhysicalResistance { get { return 2; } }
        public override int BaseFireResistance { get { return 1; } }
        public override int BaseColdResistance { get { return 2; } }
        public override int BasePoisonResistance { get { return 4; } }
        public override int BaseEnergyResistance { get { return 1; } }

        public override int InitMinHits { get { return 25; } }
        public override int InitMaxHits { get { return 30; } }

		public override Race RequiredRace { get { return Race.Elf; } }
		[Constructable]
		public SilkElvenDarkShirt() : this( 0 )
		{
		}

		[Constructable]
		public SilkElvenDarkShirt( int hue ) : base( 0x3176, hue )
		{
			Weight = 2.0;
            Name = "Elven Dark Silk Shirt";
		}

        public SilkElvenDarkShirt(Serial serial)
            : base(serial)
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.WriteEncodedInt( 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadEncodedInt();
		}
	}
}